@echo off
setlocal enabledelayedexpansion
title CLS Team - Advanced Gaming Boost

echo CLS Team - Advanced Gaming Optimizations
echo ========================================

echo Applying comprehensive gaming optimizations...
echo.

echo [1/4] POWER SETTINGS...
call :SetHighPerformance
echo.

echo [2/4] GPU & HARDWARE ACCELERATION...
call :EnableHardwareAccel
echo.

echo [3/4] GAME MODE & DVR...
call :EnableGameMode
echo.

echo [4/4] SYSTEM TWEAKS...
call :SystemTweaks
echo.

echo =======================================
echo ALL OPTIMIZATIONS COMPLETED!
echo Restart your PC for best results.
pause
exit /b

:SetHighPerformance
echo   Setting Ultimate Performance plan...
powercfg /duplicatescheme e9a42b02-d5df-448d-aa00-03f14749eb61 >nul 2>&1
powercfg /setactive e9a42b02-d5df-448d-aa00-03f14749eb61 >nul 2>&1
if %errorlevel% neq 0 powercfg /setactive 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c >nul

echo   Optimizing processor performance...
powercfg /setacvalueindex SCHEME_CURRENT 54533251-82be-4824-96c1-47b60b740d00 75b0ae3f-bce0-45a7-8c89-c9611c25e100 1 >nul
powercfg /setacvalueindex SCHEME_CURRENT 54533251-82be-4824-96c1-47b60b740d00 bc5038f7-23e0-4960-96da-33abaf5935ec 100 >nul
echo   Power settings optimized.
exit /b

:EnableHardwareAccel
echo   Enabling GPU Hardware Scheduling...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\GraphicsDrivers" /v "HwSchMode" /t REG_DWORD /d 2 /f >nul 2>&1

echo   Configuring NVIDIA optimizations...
reg add "HKCU\Software\NVIDIA Corporation\Global\NVTweak" /v "SeLowPowerGpuOnBattery" /t REG_DWORD /d 0 /f >nul 2>&1
reg add "HKCU\Software\NVIDIA Corporation\Global\NVTweak" /v "SeLowPowerGpuOnPower" /t REG_DWORD /d 0 /f >nul 2>&1

echo   Disabling Xbox DVR...
reg add "HKCU\System\GameConfigStore" /v "GameDVR_Enabled" /t REG_DWORD /d 0 /f >nul
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\GameDVR" /v "AllowGameDVR" /t REG_DWORD /d 0 /f >nul 2>&1
echo   Hardware acceleration enabled.
exit /b

:EnableGameMode
echo   Enabling Windows Game Mode...
reg add "HKCU\Software\Microsoft\GameBar" /v "AllowAutoGameMode" /t REG_DWORD /d 1 /f >nul
reg add "HKCU\Software\Microsoft\GameBar" /v "AutoGameModeEnabled" /t REG_DWORD /d 1 /f >nul

echo   Optimizing for fullscreen games...
reg add "HKCU\System\GameConfigStore" /v "GameDVR_DXGIHonorFSEWindowsCompatible" /t REG_DWORD /d 1 /f >nul
reg add "HKCU\System\GameConfigStore" /v "GameDVR_FSEBehaviorMode" /t REG_DWORD /d 2 /f >nul
echo   Game Mode configured.
exit /b

:SystemTweaks
echo   Applying system performance tweaks...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\PriorityControl" /v "Win32PrioritySeparation" /t REG_DWORD /d 38 /f >nul 2>&1
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "NetworkThrottlingIndex" /t REG_DWORD /d 4294967295 /f >nul
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "SystemResponsiveness" /t REG_DWORD /d 0 /f >nul
echo   System tweaks applied.
exit /b